#!/bin/sh

cd $(dirname $0)

cd deploy

PGID=` cat /proc/$$/stat | awk '{print $5}'`
TEMPPATH="/mnt/data/.installrt/pewconfig"
CONFIGPATH="/mnt/data/hmi/pew/deploy/node/config/"

# Find out the mainos BSP Version number to check if the apps should be started
RES=$(dbus-send --print-reply --system --dest=com.exor.EPAD "/MainOSInfo" com.exor.EPAD.PartitionInfo.infoJSON)
FINDSTRING="version"
POSITION="${RES%%$FINDSTRING*}"
POSITION="${#POSITION}"
POSITION=$((POSITION + 8))
STRING_START_FROM_VER=${RES:POSITION:20}
VER_NUMBER="${STRING_START_FROM_VER#*\"}"  # Removes everything before the first quote
VER="${VER_NUMBER%%\"*}"
VERSION=$(echo "$VER" | awk -F. '{for(i=1; i<=NF; i++) $i+=0; OFS="."} 1')
#Version number as numeric
VERSION=$(echo "$VER" | tr -d '.')
#in bsp version < 1.3 the version cant be read with dbus, if variable is empty assume that bsp is 1.0
if [ -z "$VERSION" ]
then
	VERSION=10000
fi
VER_MIN=13000
VER_31=31000

#copy new nginx file in case bsp version is higher than 3.1
if [ $VERSION -gt $VER_31 ]
then
	cp /mnt/data/hmi/pew/deploy/nginx_temp/fp_config_bsp31.conf /mnt/data/hmi/pew/nginx/fp_config.conf
fi

echo $PGID > /var/run/pew_main.pid # save pid for termination
(
    # export required variables (not availables if started by jmlauncher daemon)
    export USER=`busybox whoami`
    export HOME=`eval echo ~$USER`
	
	# check if there is a backup folder of config files
	if [ -d $TEMPPATH ]
	then
		cp -a $TEMPPATH/. $CONFIGPATH
		rm -r $TEMPPATH
	fi

	if [ $VERSION -gt $VER_MIN ]
	then
		echo "Starting FP-I4C system as user \"$USER\" with home \"$HOME\""
		./start_node.sh $@ &
		./start_redirect.sh $@ &
		./start_log.sh $@ &
		./start_mqtt.sh $@ &
		./start_script.sh $@ &
		./start_httpc.sh $@ &
		./start_ftpc.sh $@ &
		./start_email.sh $@ &
		./start_60870.sh $@ &
		./start_main.sh $@;
		dbus-send --print-reply --system --dest=com.exor.JMLauncher '/' com.exor.JMLauncher.appFinished string:"FP-I4C"
		PID="$(cat /var/run/pew_main.pid)"
		rm /var/run/pew_main.pid
		pkill -TERM  -s $PID;       # kill all child spawned processes if any
	else
		echo "Error: The BSP version is not compatible to the Firmware version"
		# Copy the nginx conf file for fp_config to the folder since the newer nginx conf file is not compatible
		cp /mnt/data/hmi/pew/deploy/nginx_temp/fp_config_bsp10.conf /mnt/data/hmi/pew/nginx/fp_config.conf
		/etc/init.d/nginx start
		./start_node.sh $@;
	fi
) &

# Wait app is started
sleep 20

if ( pgrep pew_main > /dev/null ); then
    # starts debugging resources (print a report every 60 minutes and check ram usage every 60 seconds)
    dbus-send --print-reply --system --dest=com.exor.EPAD /SysStat com.exor.EPAD.SysStat.monitorSystemResources int32:60 int32:60

    dbus-send --print-reply --system --dest=com.exor.JMLauncher '/' com.exor.JMLauncher.appLoaded string:"FP-I4C"
fi
